class Oyun {
constructor() {
this.STATES = {
'YUKLENIYOR': 'yükleniyor',
'OYNANIYOR': 'oynaniyor',
'HAZIR': 'hazir',
'BITTI': 'bitti',
'SIFIRLANIYOR': 'sifirlaniyor'
};
this.blocks = [];
this.state = this.STATES.YUKLENIYOR;
this.stage = new Bolum();
this.mainContainer = document.getElementById('container');
this.scoreContainer = document.getElementById('skor');
this.startButton = document.getElementById('basla-buton');
this.instructions = document.getElementById('talimatlar');
this.scoreContainer.innerHTML = '0';
this.newBlocks = new THREE.Group();
this.placedBlocks = new THREE.Group();
this.choppedBlocks = new THREE.Group();
this.stage.add(this.newBlocks);
this.stage.add(this.placedBlocks);
this.stage.add(this.choppedBlocks);
this.blokEkle();
this.tik();
this.yerGuncelle(this.STATES.HAZIR);
document.addEventListener('keydown', e => {
if (e.keyCode == 32)
this.hareket();
});
document.addEventListener('click', e => {
this.hareket();
});
document.addEventListener('touchstart', e => {
e.preventDefault();
});
}
yerGuncelle(newState) {
for (let key in this.STATES)
this.mainContainer.classList.remove(this.STATES[key]);
this.mainContainer.classList.add(newState);
this.state = newState;
}
hareket() {
switch (this.state) {
case this.STATES.HAZIR:
this.oyunBaslat();
break;
case this.STATES.OYNANIYOR:
this.blokYerlestir();
break;
case this.STATES.BITTI:
this.yenidenBaslat();
break;
}
}
oyunBaslat() {
if (this.state != this.STATES.OYNANIYOR) {
this.scoreContainer.innerHTML = '0';
this.yerGuncelle(this.STATES.OYNANIYOR);
this.blokEkle();
}
}
yenidenBaslat() {
this.yerGuncelle(this.STATES.SIFIRLANIYOR);
let oldBlocks = this.placedBlocks.children;
let removeSpeed = 0.2;
let delayAmount = 0.02;
for (let i = 0; i < oldBlocks.length; i++) {
TweenLite.to(oldBlocks[i].scale, removeSpeed, { x: 0, y: 0, z: 0, delay: (oldBlocks.length - i) * delayAmount, ease: Power1.easeIn, onComplete: () => this.placedBlocks.remove(oldBlocks[i]) });
TweenLite.to(oldBlocks[i].rotation, removeSpeed, { y: 0.5, delay: (oldBlocks.length - i) * delayAmount, ease: Power1.easeIn });
}
let cameraMoveSpeed = removeSpeed * 2 + (oldBlocks.length * delayAmount);
this.stage.kameraAyarla(2, cameraMoveSpeed);
let countdown = { value: this.blocks.length - 1 };
TweenLite.to(countdown, cameraMoveSpeed, { value: 0, onUpdate: () => { this.scoreContainer.innerHTML = String(Math.round(countdown.value)); } });
this.blocks = this.blocks.slice(0, 1);
setTimeout(() => {
this.oyunBaslat();
}, cameraMoveSpeed * 1000);
}
blokYerlestir() {
let currentBlock = this.blocks[this.blocks.length - 1];
let newBlocks = currentBlock.place();
this.newBlocks.remove(currentBlock.mesh);
if (newBlocks.placed)
this.placedBlocks.add(newBlocks.placed);
if (newBlocks.chopped) {
this.choppedBlocks.add(newBlocks.chopped);
let positionParams = { y: '-=30', ease: Power1.easeIn, onComplete: () => this.choppedBlocks.remove(newBlocks.chopped) };
let rotateRandomness = 10;
let rotationParams = {
delay: 0.05,
x: newBlocks.plane == 'z' ? ((Math.random() * rotateRandomness) - (rotateRandomness / 2)) : 0.1,
z: newBlocks.plane == 'x' ? ((Math.random() * rotateRandomness) - (rotateRandomness / 2)) : 0.1,
y: Math.random() * 0.1,
};
if (newBlocks.chopped.position[newBlocks.plane] > newBlocks.placed.position[newBlocks.plane]) {
positionParams[newBlocks.plane] = '+=' + (40 * Math.abs(newBlocks.direction));
}
else {
positionParams[newBlocks.plane] = '-=' + (40 * Math.abs(newBlocks.direction));
}
TweenLite.to(newBlocks.chopped.position, 1, positionParams);
TweenLite.to(newBlocks.chopped.rotation, 1, rotationParams);
}
this.blokEkle();
}
blokEkle() {
let lastBlock = this.blocks[this.blocks.length - 1];
if (lastBlock && lastBlock.state == lastBlock.STATES.MISSED) {
return this.oyunBitir();
}
this.scoreContainer.innerHTML = String(this.blocks.length - 1);
let newKidOnTheBlock = new Blok(lastBlock);
this.newBlocks.add(newKidOnTheBlock.mesh);
this.blocks.push(newKidOnTheBlock);
this.stage.kameraAyarla(this.blocks.length * 2);
if (this.blocks.length >= 5)
this.instructions.classList.add('gizle');
}
oyunBitir() {
this.yerGuncelle(this.STATES.BITTI);
}
tik() {
this.blocks[this.blocks.length - 1].tik();
this.stage.render();
requestAnimationFrame(() => { this.tik(); });
}
}
let oyun = new Oyun();