<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<meta http-equiv="X-UA-Compatible" content="ie=edge" />
	<title>Döviz Kuru Hesaplayıcı</title>
	<link rel="stylesheet" href="css/style.css" />
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
</head>
<body>
	<img src="images/logo.png" alt="" class="money-img" />
	<h1>Döviz Kuru Hesaplayıcı</h1>
	<p>Çeviri işlemi için para birimini ve miktarı seçiniz</p>
	<div class="container" id="yuklenenler">
		<div class="currency">
			<select id="currency-one" onchange="cevir();">
			<?php 
			$curl4 = curl_init("https://bdryazilim.com/api/api.php?talep=PARABIRIMLERI");
			curl_setopt($curl4, CURLOPT_RETURNTRANSFER, true);
			$cevap = curl_exec($curl4);
			curl_close($curl4);
			$sonuc = json_decode($cevap, true);
			if ($sonuc["kod"] == "900") {
				foreach($sonuc["para_birimi"] as $icerik) {
					$kod=$icerik["kod"];
					$para=$icerik["para"];
			?>
				<option value="<?php echo $kod; ?>" <?php if($kod=="TRY") {echo "selected";} ?>><?php echo $kod." - ".$para; ?></option>
			<?php } } ?>
			</select>
			<input type="number" id="amount-one" placeholder="0" value="1" onchange="cevir();" />
		</div>

		<div class="swap-rate-container">
			<button id="swap" onclick="degistir();"><i class="fa-solid fa-arrow-right-arrow-left btn"></i></button>
			<div class="rate" id="rate"></div>
		</div>

		<div class="currency">
			<select id="currency-two" onchange="cevir();">
				<?php 
					foreach($sonuc["para_birimi"] as $icerik) {
						$kod=$icerik["kod"];
						$para=$icerik["para"];
				?>
					<option value="<?php echo $kod; ?>" <?php if($kod=="EUR") {echo "selected";} ?>><?php echo $kod." - ".$para; ?></option>
				<?php } ?>
			</select>
			<input type="number" id="amount-two" placeholder="0" onchange="cevir();" />
		</div>
	</div>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js" integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
	<script src="js/script.js"></script>
</body>
</html>
