<?php 
include("fonksiyonlar.php");
$aranan="Istanbul";
$limit=1;
$ilResim="";
$ResimArama = new ResimArama();
$resimler = $ResimArama->Ara($aranan, $limit);
foreach($resimler as $icerik) {$ilResim=$icerik["uri"];}
$turkceGun = $turkceGunler[date('N') - 1];
$url="http://api.weatherapi.com/v1/forecast.json?key=$apikey&q=$aranan&days=4&lang=tr";

$json = file_get_contents($url);
$json = json_decode($json);
$sicaklik = $json->current->temp_c;
$durum = $json->current->condition->text;
$ikon = $json->current->condition->icon;
$basinc=$json->current->pressure_mb;
$nem=$json->current->humidity;
$ruzgar=$json->current->wind_kph;
$sonraki=$json->forecast->forecastday;
$sonraki_gunsayi=count($sonraki);
?>
<!DOCTYPE html>
<html lang="en" >
<head>
  	<meta charset="UTF-8">
  	<title> Hava Durumu Uygulaması </title>
  	<link rel="stylesheet" href="css/style.css">
  	<script src="https://unpkg.com/feather-icons"></script>
</head>
<body>
	<div class="container" id="yuklenenler">
  		<div class="weather-side" style="background-image: url(<?php echo $ilResim; ?>);">
    		<div class="weather-gradient"></div>
    		<div class="date-container">
      			<h2 class="date-dayname"><?php echo $turkceGun; ?></h2><span class="date-day"><?php echo date("d.m.Y"); ?></span><i class="location-icon" data-feather="map-pin"></i><span class="location">Istanbul, TR</span>
    		</div>
			<div class="weather-container">
				<img class="weather-icon" src="<?php echo $ikon; ?>" alt="<?php echo $durum; ?>"/>
				<h1 class="weather-temp"><?php echo $sicaklik; ?>°C</h1>
				<h3 class="weather-desc"><?php echo $durum; ?></h3>
			</div>
  		</div>
  		<div class="info-side">
    		<div class="today-info-container">
     		 	<div class="today-info">
       				 <div class="precipitation"> 
						<span class="title">BASINÇ</span>
						<span class="value"><?php echo $basinc; ?> mb</span>
          				<div class="clear"></div>
        			</div>
        			<div class="humidity"> 
						<span class="title">NEM</span>
						<span class="value"><?php echo $nem; ?> %</span>
          				<div class="clear"></div>
        			</div>
        			<div class="wind"> 
						<span class="title">RÜZGAR</span>
						<span class="value"><?php echo $ruzgar; ?> km/h</span>
          				<div class="clear"></div>
        			</div>
      			</div>
    		</div>
    		<div class="week-container">
      			<ul class="week-list">
					<?php 
					$say=-1;
					for($i=0;$i<$sonraki_gunsayi; $i++){
						$tarih = $json->forecast->forecastday[$i]->date_epoch;
						$ikon = $json->forecast->forecastday[$i]->day->condition->icon;
						$maks_sicaklik=$json->forecast->forecastday[$i]->day->maxtemp_c;
						$min_sicaklik=$json->forecast->forecastday[$i]->day->mintemp_c;
						$tarih = getdate($tarih);
						$gunusira=date("N")  + $say;
						
						$turkceGun = $turkceGunler[$gunusira];
						if($gunusira=="7") {$turkceGun = $turkceGunler[0];}
						if($gunusira=="8") {$turkceGun = $turkceGunler[1];}
						if($gunusira=="9") {$turkceGun = $turkceGunler[2];}
						if($gunusira=="10") {$turkceGun = $turkceGunler[3];}
					?>
       				 <li class="<?php if($i==0) {echo "active";} ?>">
						<img class="day-icon" src="<?php echo $ikon; ?>" alt="<?php echo $durum; ?>"/>
						<span class="day-name"><?php echo $turkceGun; ?></span>
						<span class="day-temp">
							<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" class="main-grid-item-icon" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
				 				 <line x1="12" x2="12" y1="19" y2="5" />
				  				<polyline points="5 12 12 5 19 12" />
							</svg>
							<?php echo $maks_sicaklik; ?>°C
						</span>
						<span class="day-temp">
							<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" class="main-grid-item-icon" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
				 				<line x1="12" x2="12" y1="5" y2="19" />
				  				<polyline points="19 12 12 19 5 12" />
							</svg>
							<?php echo $min_sicaklik; ?>°C
						</span>
					</li>
					<?php $say++; } ?>
					<div class="clear"></div>
      			</ul>
   			</div>
			<div class="location-container">
				<div class="select">
					<select id="sehir" name="sehir" onchange="havaDurumu_getir();">
						<option value="istanbul" selected>Istanbul</option>
						<option value="ankara">Ankara</option>
						<option value="izmir">İzmir</option>
						<option value="adana">Adana</option>
						<option value="bursa">Bursa</option>
						<option value="trabzon">Trabzon</option>
						<option value="van">Van</option>
						<option value="edirne">Edirne</option>
						<option value="mugla">Muğla</option>
						<option value="canakkale">Çanakkale</option>
						<option value="sivas">Sivas</option>
					</select>
				</div>
			</div>
  		</div>
	</div>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js" integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
	<script  src="js/script.js"></script>
</body>
</html>
