<?php 
$apikey=""; //https://newsdata.io/ web sitesinden ücretsiz api alacaksınız.
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>PHP News Api ile Haber Sitesi Yapımı</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="Haber Sitesi" name="keywords">
    <meta content="Haber Sitesi" name="description">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">  
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.0/css/all.min.css" rel="stylesheet">
    <link href="css/assets/owl.carousel.min.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
</head>
<body>
    <div class="container-fluid pt-0">
		<div class="container">
			<nav class="navbar navbar-expand-lg bg-dark navbar-dark py-2 py-lg-0 px-lg-5">
				<a href="index.php" class="navbar-brand d-block">
					<h1 class="m-0 display-6 text-uppercase text-primary">HABER<span class="text-white font-weight-normal">SİTESİ</span></h1>
				</a>
				<button type="button" class="navbar-toggler" data-toggle="collapse" data-target="#navbarCollapse">
					<span class="navbar-toggler-icon"></span>
				</button>
				<div class="collapse navbar-collapse justify-content-between px-0 px-lg-3" id="navbarCollapse">
					<div class="navbar-nav mr-auto py-0">
						<a href="index.php" class="nav-item nav-link active">Anasayfa</a>
						<a href="kategoriler.php" class="nav-item nav-link">Kategoriler</a>
						<a href="hakkimizda.php" class="nav-item nav-link">Hakkımızda</a>
						<a href="iletisim.php" class="nav-item nav-link">İletişim</a>
					</div>
					<form action="arama.php" method="post">
						<div class="input-group ml-auto d-none d-lg-flex" style="width: 100%; max-width: 300px;">
								<input type="text" class="form-control border-0" id="arama" name="arama" placeholder="Ara...">
								<div class="input-group-append">
									<button class="input-group-text bg-primary border-0 px-3">
										<i class="fa fa-search"></i>
									</button>
								</div>
						</div>
					</form>
				</div>
			</nav>
		</div>
    </div>
    <div class="container-fluid">
		<div class="container">
			<div class="row">
				<div class="col-lg-7 px-0">
					<div class="owl-carousel main-carousel position-relative">
						<?php 
						$url="https://newsdata.io/api/1/news?apikey=$apikey&category=top&language=tr";
						$json = file_get_contents($url);
						$json = json_decode($json);
						for($i=0;$i<6; $i++){
							$kaynak=$json->results[$i]->source_id;
							$tarihi=$json->results[$i]->pubDate;
							$kapak=$json->results[$i]->image_url;
							if (@getimagesize($kapak)) {} else {
								$kapak="img/resim-yok.png";
							}
							$baslik=$json->results[$i]->title;
							$link=$json->results[$i]->link;
							$tarihisaati=explode(" ", $tarihi);
							$tarihim=$tarihisaati[0];
							$saatim=$tarihisaati[1];
						
						?>
						<div class="position-relative overflow-hidden" style="height: 500px;">
							<img class="img-fluid h-100" src="<?php echo $kapak; ?>" style="object-fit: cover;">
							<div class="overlay">
								<div class="mb-2">
									<a class="badge badge-primary text-uppercase font-weight-semi-bold p-2 mr-2"
										href="">Güncel</a>
									<a class="text-white" href=""><?php echo $tarihim." - ".$saatim; ?></a>
								</div>
								<a class="h5 m-0 text-white text-uppercase font-weight-bold" href="<?php echo $link; ?>" target="_blank">
								<?php echo $baslik; ?>
								</a>
							</div>
						</div>
						<?php } ?>
					</div>
				</div>
				<div class="col-lg-5 px-0">
					<div class="row mx-0">
					
						<?php 
						for($i=6;$i<10; $i++){
							$kaynak=$json->results[$i]->source_id;
							$tarihi=$json->results[$i]->pubDate;
							$kapak=$json->results[$i]->image_url;
							if (@getimagesize($kapak)) {} else {
								$kapak="img/resim-yok.png";
							}
							$baslik=$json->results[$i]->title;
							$link=$json->results[$i]->link;
							$tarihim=$tarihisaati[0];
							$saatim=$tarihisaati[1];
						?>
					
						<div class="col-md-6 px-0">
							<div class="position-relative overflow-hidden" style="height: 250px;">
								<img class="img-fluid w-100 h-100" src="<?php echo $kapak; ?>" style="object-fit: cover;">
								<div class="overlay">
									<div class="mb-2">
										<a class="badge badge-primary text-uppercase font-weight-semi-bold p-2 mr-2"
											href="">Güncel</a>
										<a class="text-white" href=""><small><?php echo $tarihim." - ".$saatim; ?></small></a>
									</div>
									<a style="font-size:12px;" class="h6 m-0 text-white text-uppercase font-weight-semi-bold" href="<?php echo $link; ?>" target="_blank">
									<?php echo $baslik; ?>
									</a>
								</div>
							</div>
						</div>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
    </div>

    <div class="container-fluid">
        <div class="container">
            <div class="row align-items-center bg-dark">
                <div class="col-12">
                    <div class="d-flex justify-content-between">
                        <div class="bg-primary text-center font-weight-medium py-2" style="width: 170px;">Son Dakika</div>
                        <div class="owl-carousel tranding-carousel position-relative d-inline-flex align-items-center ml-3"
                            style="width: calc(100% - 170px); padding-right: 90px;">
							<?php 
							for($i=0;$i<10; $i++){
								$baslik=$json->results[$i]->title;
								$link=$json->results[$i]->link;
							?>
                            <div class="text-truncate">
								<a class="text-white text-uppercase font-weight-semi-bold" href="<?php echo $link; ?>" target="_blank"><?php echo $baslik; ?></a>
							</div>
							<?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
	
    <div class="container-fluid pt-3">
        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <div class="row">
                        <div class="col-12">
                            <div class="section-title">
                                <h4 class="m-0 text-uppercase font-weight-bold">Politika</h4>
                                <a class="text-secondary font-weight-medium text-decoration-none" href="kategori.php?cat=politics">Tümünü Gör</a>
                            </div>
                        </div>
						<?php 
						$url2="https://newsdata.io/api/1/news?apikey=$apikey&category=politics&language=tr";
						$json = file_get_contents($url2);
						$json = json_decode($json);
						for($i=0;$i<4; $i++){
							$kaynak=$json->results[$i]->source_id;
							$tarihi=$json->results[$i]->pubDate;
							$kapak=$json->results[$i]->image_url;
							if (@getimagesize($kapak)) {} else {
								$kapak="img/resim-yok.png";
							}
							$baslik=$json->results[$i]->title;
							$link=$json->results[$i]->link;
							$tarihisaati=explode(" ", $tarihi);
							$tarihim=$tarihisaati[0];
							$saatim=$tarihisaati[1];
						?>
                        <div class="col-lg-6">
                            <div class="position-relative mb-3">
                                <img class="img-fluid w-100" src="<?php echo $kapak; ?>" style="object-fit: cover;">
                                <div class="bg-white border border-top-0 p-4">
                                    <div class="mb-2">
                                        <a class="badge badge-primary text-uppercase font-weight-semi-bold p-2 mr-2"
                                            href="">Politika</a>
                                        <a class="text-body" href=""><small><?php echo $tarihim." - ".$saatim; ?></small></a>
                                    </div>
                                    <a class="h6 d-block mb-3 text-secondary text-uppercase font-weight-bold" href="<?php echo $link; ?>" target="_blank">
									<?php echo $baslik; ?>
									</a>
                                </div>
                                <div class="d-flex justify-content-between bg-white border border-top-0 p-4">
                                    <div class="d-flex justify-content-center">
                                        <small>Kaynak: </small>
										<h6 class="pl-2"><?php echo $kaynak; ?></h6>
                                    </div>
                                   
                                </div>
                            </div>
                        </div>
                        <?php } ?>
						
                    </div>
                </div>
                
                <div class="col-lg-4">
                    <div class="mb-3">
                        <div class="section-title mb-0">
                            <h4 class="m-0 text-uppercase font-weight-bold">Takip Edin</h4>
                        </div>
                        <div class="bg-white border border-top-0 p-3">
                             <div class="d-flex justify-content-start">
								<a class="btn btn-lg btn-secondary btn-lg-square mr-2" href="#"><i class="fab fa-twitter"></i></a>
								<a class="btn btn-lg btn-secondary btn-lg-square mr-2" href="#"><i class="fab fa-facebook-f"></i></a>
								<a class="btn btn-lg btn-secondary btn-lg-square mr-2" href="#"><i class="fab fa-linkedin-in"></i></a>
								<a class="btn btn-lg btn-secondary btn-lg-square mr-2" href="#"><i class="fab fa-instagram"></i></a>
								<a class="btn btn-lg btn-secondary btn-lg-square" href="#"><i class="fab fa-youtube"></i></a>
							</div>
                        </div>
                    </div>
 
                    <div class="mb-3">
                        <div class="section-title mb-0">
                            <h4 class="m-0 text-uppercase font-weight-bold">Reklam Alanı</h4>
                        </div>
                        <div class="bg-white text-center border border-top-0 p-3">
                            <a href=""><img class="img-fluid" src="img/reklam.png" alt=""></a>
                        </div>
                    </div>

                    <div class="mb-3">
                        <div class="section-title mb-0">
                            <h4 class="m-0 text-uppercase font-weight-bold">Abone Ol</h4>
                        </div>
                        <div class="bg-white text-center border border-top-0 p-3">
                            <p>En güncel haberleri öğrenmek için bültenimize abone olun.</p>
                            <div class="input-group mb-2" style="width: 100%;">
                                <input type="text" class="form-control form-control-lg" placeholder="E-Posta Adresiniz">
                                <div class="input-group-append">
                                    <button class="btn btn-primary font-weight-bold px-3">Abone Ol</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="section-title mb-0">
                            <h4 class="m-0 text-uppercase font-weight-bold">Etiketler</h4>
                        </div>
                        <div class="bg-white border border-top-0 p-3">
                            <div class="d-flex flex-wrap m-n1">
                                <a href="kategori.php?cat=business" class="btn btn-sm btn-outline-secondary m-1">İş</a>
                                <a href="kategori.php?cat=crime" class="btn btn-sm btn-outline-secondary m-1">Suç</a>
                                <a href="kategori.php?cat=domestic" class="btn btn-sm btn-outline-secondary m-1">Yerel</a>
                                <a href="kategori.php?cat=education" class="btn btn-sm btn-outline-secondary m-1">Eğitim</a>
                                <a href="kategori.php?cat=entertainment" class="btn btn-sm btn-outline-secondary m-1">Eğlence</a>
                                <a href="kategori.php?cat=environment" class="btn btn-sm btn-outline-secondary m-1">Çevre</a>
                                <a href="kategori.php?cat=food" class="btn btn-sm btn-outline-secondary m-1">Yemek</a>
                                <a href="kategori.php?cat=health" class="btn btn-sm btn-outline-secondary m-1">Sağlık</a>
                                <a href="kategori.php?cat=other" class="btn btn-sm btn-outline-secondary m-1">Diğer</a>
                                <a href="kategori.php?cat=politics" class="btn btn-sm btn-outline-secondary m-1">Politika</a>
								<a href="kategori.php?cat=science" class="btn btn-sm btn-outline-secondary m-1">Bilim</a>
								<a href="kategori.php?cat=sports" class="btn btn-sm btn-outline-secondary m-1">Spor</a>
								<a href="kategori.php?cat=technology" class="btn btn-sm btn-outline-secondary m-1">Teknoloji</a>
								<a href="kategori.php?cat=top" class="btn btn-sm btn-outline-secondary m-1">Gündem</a>
								<a href="kategori.php?cat=tourism" class="btn btn-sm btn-outline-secondary m-1">Turizm</a>
								<a href="kategori.php?cat=world" class="btn btn-sm btn-outline-secondary m-1">Dünya</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container-fluid py-4 px-sm-3 px-md-5" style="background: #111111;">
        <p class="m-0 text-center">&copy; <a href="#">Haber Sitesi @ 2023</a>. Tüm Hakları Saklıdır.</p>
    </div>
    <a href="#" class="btn btn-primary btn-square back-to-top"><i class="fa fa-arrow-up"></i></a>
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.bundle.min.js"></script>
    <script src="js/easing/easing.min.js"></script>
    <script src="js/owlcarousel/owl.carousel.min.js"></script>
    <script src="js/main.js"></script>
</body>

</html>