var input = document.getElementById("resim");
var resim_data;

var convertBase64 = (file) => {
	return new Promise((resolve, reject) => {
		var fileReader = new FileReader();
		fileReader.readAsDataURL(file);

		fileReader.onload = () => {
			resolve(fileReader.result);
		};

		fileReader.onerror = (error) => {
			reject(error);
		};
	});
};

var uploadImage = async (event) => {
	var file = event.target.files[0];
	var base64 = await convertBase64(file);
	resim_data = base64;
};

input.addEventListener("change", (e) => {
	uploadImage(e);
});


function sor() {
	var prompt = document.getElementById("prompt").value;
	var sc='&resim_data='+resim_data+'&prompt='+prompt;
	
	$.ajax({
		url: "gemini/gemini_resim.php",
		type: "POST",
		processData: false,
		data: sc,
		enctype: 'multipart/form-data',
		success: function (ajaxCevap) {
			$("div#kabuk").append(ajaxCevap);
			$(document).ready(function() {
				$("#bugun").html("");
				$('#chat_area').animate({
					scrollTop: $('#chat_area').get(0).scrollHeight
				}, 1000);
			});
		}
	});
}	