$(document).ready(() => {
    $('#hamburger-menu').click(() => {
        $('#hamburger-menu').toggleClass('active')
        $('#nav-menu').toggleClass('active')
    })

    let navText = ["<i class='bx bx-chevron-left'></i>", "<i class='bx bx-chevron-right'></i>"]

    $('#hero-carousel').owlCarousel({
        items: 1,
        dots: false,
        loop: true,
        nav:true,
        navText: navText,
        autoplay: true,
        autoplayHoverPause: true
    })

    $('#top-movies-slide').owlCarousel({
        items: 2,
        dots: false,
        loop: true,
        autoplay: true,
        autoplayHoverPause: true,
        responsive: {
            500: {
                items: 3
            },
            1280: {
                items: 4
            },
            1600: {
                items: 6
            }
        }
    })

    $('.movies-slide').owlCarousel({
        items: 2,
        dots: false,
        nav:true,
        navText: navText,
        margin: 15,
        responsive: {
            500: {
                items: 2
            },
            1280: {
                items: 4
            },
            1600: {
                items: 6
            }
        }
    })
	
	const ratings = document.querySelectorAll(".ratingi");

	ratings.forEach((rating) => {
	  const ratingContent = rating.innerHTML;
	  const ratingScore = parseInt(ratingContent, 10);

	  const scoreClass =
		ratingScore < 50 ? "bad" : ratingScore < 74 ? "meh" : "good";
	  rating.classList.add(scoreClass);

	  const ratingColor = window.getComputedStyle(rating).backgroundColor;

	  const gradient = `background: conic-gradient(${ratingColor} ${ratingScore}%, transparent 0 100%)`;

	  rating.setAttribute("style", gradient);

	  rating.innerHTML = `<span>${ratingScore} ${
		ratingContent.indexOf("%") >= 0 ? "<small>%</small>" : ""
	  }</span>`;
	});
	
})

