const popup = document.querySelector(".popup");
const ikon = document.querySelector(".ikon i");
const baslik = document.querySelector(".popup .baslik");
const aciklama = document.querySelector(".aciklama");
const yeniden = document.querySelector(".yeniden");

let cevrimici = true, degisId, zamanlayici = 10;

const baglantiKontrol = async () => {
    try{
        const response = await fetch("https://jsonplaceholder.typicode.com/posts/1");
        cevrimici = response.status >= 200 && response.status < 300;
    } catch (error) {
        cevrimici = false;
    }
    zamanlayici = 10;
    clearInterval(degisId);
    popupAc(cevrimici);
}

const popupAc = (status) => {
    if(status){
        ikon.className = "uil uil-wifi";
        baslik.innerText = "Yenilenen Bağlantı";
        aciklama.innerHTML = "Cihazınız internete başarılı bir şekilde bağlandı.";
        popup.classList.add("cevrimici");
        return setTimeout(() => 
            popup.classList.remove("show"), 2000);
    }
    ikon.className = "uil uil-wifi-slash";
    baslik.innerText = "Bağlantı Koptu";
    aciklama.innerHTML = "Bağlantınız uygun değil. 10 saniye içinde tekrar deneyeceğiz.";
    popup.className = "popup show";
    degisId = setInterval(() => {
        zamanlayici--;
        if(zamanlayici === 0){
            baglantiKontrol();
            popup.querySelector(".aciklama b").innerText = zamanlayici;
        }
    }, 1000);
}
setInterval(() => cevrimici && baglantiKontrol(), 3000);
yeniden.addEventListener("click", baglantiKontrol);