const wordDisplay = document.querySelector(".word-display");
const guessesText = document.querySelector(".guesses-text b");
const keyboardDiv = document.querySelector(".keyboard");
const hangmanImage = document.querySelector(".hangman-box img");
const gameModal = document.querySelector(".game-modal");
const playAgainBtn = gameModal.querySelector("button");

let currentWord, correctLetters, wrongGuessCount;
const maxGuesses = 6;

const resetGame = () => {
correctLetters = [];
wrongGuessCount = 0;
hangmanImage.src = "images/hangman-0.svg";
guessesText.innerText = `${wrongGuessCount} / ${maxGuesses}`;
wordDisplay.innerHTML = currentWord.split("").map(() => `<li class="letter"></li>`).join("");
keyboardDiv.querySelectorAll("button").forEach(btn => btn.disabled = false);
gameModal.classList.remove("show");
}

const getRandomWord = () => {
const { word, hint } = kelimeler[Math.floor(Math.random() * kelimeler.length)];
currentWord = word;
document.querySelector(".hint-text b").innerText = hint;
resetGame();
}

const gameOver = (isVictory) => {
const modalText = isVictory ? `Bulunan kelime:` : 'Doğru kelime:';
gameModal.querySelector("img").src = `images/${isVictory ? 'kazanan' : 'kaybeden'}.gif`;
gameModal.querySelector("h4").innerText = isVictory ? 'Tebrikler!' : 'Oyun Bitti!';
gameModal.querySelector("p").innerHTML = `${modalText} <b>${currentWord}</b>`;
gameModal.classList.add("show");
}

const initGame = (button, clickedLetter) => {
if(currentWord.includes(clickedLetter)) {
[...currentWord].forEach((letter, index) => {
if(letter === clickedLetter) {
correctLetters.push(letter);
wordDisplay.querySelectorAll("li")[index].innerText = letter;
wordDisplay.querySelectorAll("li")[index].classList.add("guessed");
}
});
} else {
wrongGuessCount++;
hangmanImage.src = `images/hangman-${wrongGuessCount}.svg`;
}
button.disabled = true;
guessesText.innerText = `${wrongGuessCount} / ${maxGuesses}`;
if(wrongGuessCount === maxGuesses) return gameOver(false);
if(correctLetters.length === currentWord.length) return gameOver(true);
}

for (let i = 97; i <= 122; i++) {
const button = document.createElement("button");
button.innerText = String.fromCharCode(i);
keyboardDiv.appendChild(button);
button.addEventListener("click", (e) => initGame(e.target, String.fromCharCode(i)));
}

getRandomWord();
playAgainBtn.addEventListener("click", getRandomWord);